// ContentsEsc_t.cpp : CContentsEsc_t Class source code
//

#include "stdafx.h"
#include "defsfile.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_SERIAL(CContentsEsc_t, CObject, 1)



// Serialize draw data
void CContentsEsc_t::Serialize(CArchive& ar)
{
    CObject::Serialize(ar);

    if (ar.IsStoring ())
        ar.Write(&m_Data,sizeof(m_Data)) ;
    else
        ar.Read(&m_Data,sizeof(m_Data)) ;
}

// Draw to Window
void CContentsEsc_t::Draw(CDC* pDC)
{
	static LOGFONT FontKind = {
	  	8,									// lfHeight
		0,									// lfWidth 
		0,									// lfEscapement
		0,									// lfOrientation
		FW_DONTCARE,						// lfWeight
		0,									// lfItalic
		0,									// lfUnderline
		0,									// lfStrikeOut
		SHIFTJIS_CHARSET,					// lfCharSet  
		OUT_CHARACTER_PRECIS,				// lfOutPrecision 
		CLIP_CHARACTER_PRECIS,				// lfClipPrecision 
		DEFAULT_QUALITY ,					// lfQuality 
		FIXED_PITCH | FF_MODERN,			// lfPitchAndFamily  
	} ;
	strcpy(FontKind.lfFaceName,"lr SVbN") ;	// lfFaceName

	CFont Font ;
	int X,Y ;
	int x1,y1,x2,y2 ;
	char  szWk[MEMLNK_ESC__t_MAX+1] ;
	LONG lfWidth ;
	LONG lfHeight;

	GPWinGetFontSize((LPCTSTR)m_Data.szString,m_Data.cFont,m_Data.iTurn,m_Data.iDirection,m_Data.cFontSize,&X,&Y) ;

	if( 0 < X ){
		x1 = m_Data.iX1 ;
		x2 = m_Data.iX1 + X ;
	} else {
		x2 = m_Data.iX1 ;
		x1 = m_Data.iX1 + X ;
	}
	if( 0 < Y ){
		y1 = m_Data.iY1 ;
		y2 = m_Data.iY1 + Y ;
	} else {
		y2 = m_Data.iY1 ;
		y1 = m_Data.iY1 + Y ;
	}


	if( m_Data.iDirection ){
		// c 擪̂P`Ȃ
		szWk[0] = m_Data.szString[0] ;
		szWk[1] = m_Data.szString[1] ;
		szWk[2] = 0 ;

		lfHeight = abs(Y);
		lfWidth  = abs(X)/2;
	} else {
		// 
		strcpy(szWk,m_Data.szString);

		lfHeight = abs(Y);
		lfWidth  = abs(X)/strlen(szWk);
	}


	FontKind.lfHeight = lfHeight ;
	FontKind.lfWidth =  lfWidth ;
	Font.CreateFontIndirect(&FontKind);
	CFont *pOldFont = pDC->SelectObject(&Font);

	CRect Rect(x1,y1,x2,y2) ;

	COLORREF OldBkColor   = pDC->SetBkColor( GpToWinColor(m_Data.cBackColor));
	COLORREF OldTextColor = pDC->SetTextColor( GpToWinColor(m_Data.cDisplayColor)) ;


	pDC->ExtTextOut( x1,y1,ETO_OPAQUE,&Rect,(LPCTSTR)szWk, NULL);

	CPen Pen(PS_DOT,1,GpToWinColor(m_Data.cDisplayColor)) ;
	CPen *pOldPen        = pDC->SelectObject(&Pen);
	pDC->MoveTo(x1,y1);
	pDC->LineTo(x1,y2);
	pDC->LineTo(x2,y2);
	pDC->LineTo(x2,y1);
	pDC->LineTo(x1,y1);
	pDC->SelectObject(pOldPen);
		

	pDC->SetBkColor( OldBkColor );
	pDC->SetTextColor( OldTextColor) ;
	pDC->SelectObject(pOldFont);
}

// Transmit the data to GP
int CContentsEsc_t::Transition( CMemSock* pCMemSock)
{
	return( pCMemSock->MtoMESC_t(m_Data.cDisplayColor,m_Data.cBackColor,m_Data.cFont,m_Data.iTurn,m_Data.iDirection,m_Data.iHalfcentering,m_Data.iEmphasis,m_Data.cSculpture,m_Data.iX1,m_Data.iY1,m_Data.cFontSize,m_Data.szString)) ;
}
